local assets=
{
	Asset("ANIM", "anim/blueprint.zip"),
	Asset("IMAGE", "images/enchantedmatter.tex"),
	Asset("ATLAS", "images/enchantedmatter.xml"),
}


local function onload(inst, data)
	if data then
		if data.recipetouse then
			inst.recipetouse = data.recipetouse
			--inst.components.teacher:SetRecipe(inst.recipetouse.."EE")
	    	--inst.components.named:SetName(STRINGS.NAMES[string.upper(inst.recipetouse)].." EE-Blueprint")
			inst:SetTeach(inst.recipetouse)
	    end
	end
end

local function onsave(inst, data)
	if inst.recipetouse then
		data.recipetouse = inst.recipetouse
	end
end

local function OnTeach(inst, learner)
	if learner.SoundEmitter then
		learner.SoundEmitter:PlaySound("dontstarve/HUD/get_gold")    
		if math.random() > 0.5 then
			SpawnPrefab("collapse_small").Transform:SetPosition(learner.Transform:GetWorldPosition())
			SpawnPrefab(inst.recipetouse).Transform:SetPosition(learner.Transform:GetWorldPosition())
		end
	end
end


local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    
    --inst.AnimState:SetBank("manrabbit_tail")
	inst.AnimState:SetBank("blueprint")
	inst.AnimState:SetBuild("blueprint")
	inst.AnimState:PlayAnimation("idle")
    MakeInventoryPhysics(inst)
    
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("inspectable")
    
	MakeSmallBurnable(inst)
    MakeSmallPropagator(inst)
    

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "blueprint"
    --inst.components.inventoryitem.atlasname = "images/enchantedmatter.xml"
    inst.components.inventoryitem:GetImage()
    inst.components.inventoryitem:GetAtlas()
    
	inst:AddComponent("named")
    inst:AddComponent("teacher")
    inst.components.teacher.onteach = OnTeach
    
	function inst:SetTeach(name)
		inst.recipetouse = name
		inst.components.teacher:SetRecipe(name.."EE")
		inst.components.named:SetName(STRINGS.NAMES[string.upper(name)].." EE-Blueprint")
	end
	
    inst.OnLoad = onload
    inst.OnSave = onsave

    

    return inst
end

return 	Prefab( "common/inventory/eeblueprint", fn, assets)